<?php
/**
 * zarincash Blocks integration for WooCommerce Checkout Block
 */

if (!defined('ABSPATH')) {
    exit;
}

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_Gateway_zarincash_Blocks extends AbstractPaymentMethodType {

    protected $name = 'zarincash';

    public function initialize() {
        $this->settings = get_option('woocommerce_zarincash_settings', []);
    }

    public function is_active() {
        return !empty($this->settings['enabled']) && 'yes' === $this->settings['enabled'];
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'wc-zarincash-blocks-integration',
            plugin_dir_url(__FILE__) . '../assets/js/checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n'
            ],
            '2.8.0', // Updated version for compact UI
            true
        );

        return ['wc-zarincash-blocks-integration'];
    }

    public function get_payment_method_data() {
        // Get zarincash gateway instance to access site info
        $gateway = new WC_Gateway_zarincash();
        $site_info = $gateway->get_site_info();
        
        return [
            'title' => !empty($site_info['site_name']) ? $site_info['site_name'] : $this->get_setting('title', 'zarincash'),
            'description' => !empty($site_info['gateway_description']) ? $site_info['gateway_description'] : $this->get_setting('description', 'Pay securely using zarincash.'),
            'supports' => ['products'],
            'testmode' => 'yes' === $this->get_setting('testmode', 'yes'),
            'site_info' => $site_info // Pass all site info to frontend
        ];
    }

    protected function get_setting($key, $default = '') {
        return isset($this->settings[$key]) ? $this->settings[$key] : $default;
    }
}
